<?php
/**
 * Plugin Name: WP All Import – Gallery Fix for JetEngine
 * Description: Automatically attaches all imported images to the post and saves their IDs in the JetEngine gallery field `_photos`.
 * Version: 1.0
 * Author: dtrabelsi
 */
defined('ABSPATH') || exit;

file_put_contents(WP_CONTENT_DIR . '/log-plugin-load.txt', "✅ Plugin chargé\n", FILE_APPEND);

// Déclaration globale hors init
$GLOBALS['bien_to_update'] = [];

add_action('pmxi_saved_post', function($post_id, $xml_node, $import_id) {
    file_put_contents(WP_CONTENT_DIR . '/log-wpai.txt', "🔥 Hook déclenché pour le post $post_id avec import_id = [$import_id]\n", FILE_APPEND);

    $GLOBALS['bien_to_update'][] = $post_id;
}, 10, 3);


add_action('shutdown', function() {
    if (empty($GLOBALS['bien_to_update'])) {
        file_put_contents(WP_CONTENT_DIR . '/log-wpai.txt', "💤 Shutdown : aucun post à traiter\n", FILE_APPEND);
        return;
    }

    foreach ($GLOBALS['bien_to_update'] as $post_id) {
        $attachments = get_posts([
            'post_type'      => 'attachment',
            'post_mime_type' => 'image',
            'numberposts'    => -1,
            'post_status'    => 'inherit',
            'orderby'        => 'menu_order',
            'order'          => 'ASC',
            'post_parent'    => $post_id
        ]);

        $ids = wp_list_pluck($attachments, 'ID');

        delete_post_meta($post_id, '_photos');
        update_post_meta($post_id, '_photos', $ids);

        file_put_contents(WP_CONTENT_DIR . '/log-wpai.txt', "🔁 FINAL $post_id → _photos: " . implode(',', $ids) . "\n", FILE_APPEND);
    }
});
