<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package reland
 */

// Header Settings
$reland_show_sticky_header = get_theme_mod('reland_show_sticky_header', false);
$sticky_header = $reland_show_sticky_header ? 'sticky-header' : 'sticky-default';

// Header Right
$reland_show_header_phone = get_theme_mod('reland_show_header_phone', false);
$reland_header_phone_text = get_theme_mod('reland_header_phone_text', __('+7 495 127 5451', 'reland'));

$reland_show_header_email = get_theme_mod('reland_show_header_email', false);
$reland_header_email_address = get_theme_mod('reland_header_email_address', __('relandgroup@mail.com', 'reland'));

$header_col_full = $reland_show_header_phone || $reland_show_header_email ? 'col-xl-8' : 'col-12';

$reland_show_mobile_social = get_theme_mod('reland_show_mobile_social', false);

?>


<!-- header-area -->
<header>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area transparent-header">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav d-flex align-items-center d-lg-block">
                            <div class="row g-0 align-items-center">

                                <?php if (!empty($reland_show_header_email)) : ?>
                                    <div class="col-xl-2">
                                        <div class="header-mail">
                                            <a href="mailto:<?php echo esc_attr($reland_header_email_address) ?>"><?php echo esc_html($reland_header_email_address) ?></a>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="<?php echo esc_attr($header_col_full); ?>">
                                    <div class="logo mobile-logo d-none">
                                        <?php reland_header_logo(); ?>
                                        <?php reland_header_sticky_logo(); ?>
                                    </div>
                                    <div id="split-menu" class="navbar-wrap main-menu d-none d-lg-flex">
                                        <?php reland_header_menu(); ?>
                                        <div class="logo">
                                            <?php reland_header_logo(); ?>
                                        </div>
                                        <div class="logo d-none">
                                            <?php reland_header_sticky_logo(); ?>
                                        </div>
                                        <ul class="navigation right"></ul>
                                    </div>
                                </div>

                                <?php if (!empty($reland_show_header_phone)) : ?>
                                    <div class="col-xl-2">
                                        <div class="header-contact text-end">
                                            <a href="tel:<?php echo esc_attr($reland_header_phone_text); ?>"><?php echo esc_html($reland_header_phone_text); ?></a>
                                        </div>
                                    </div>
                                <?php endif; ?>

                            </div>
                            <div class="mobile-nav-toggler"><i class="fas fa-bars"></i></div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu  -->
    <div class="mobile-menu">
        <nav class="menu-box">
            <div class="close-btn"><i class="fas fa-times"></i></div>
            <div class="nav-logo">
                <?php reland_mobile_logo(); ?>
            </div>
            <div class="menu-outer">
                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
            </div>
            <?php if (!empty($reland_show_mobile_social)) : ?>
                <div class="social-links">
                    <?php reland_mobile_social_profiles(); ?>
                </div>
            <?php endif; ?>
        </nav>
    </div>
    <div class="menu-backdrop"></div>
    <!-- End Mobile Menu -->
</header>
<!-- header-area-end -->