<?php

/**
 * Template part for displaying footer layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package reland
 */

$footer_bg_img = get_theme_mod('reland_footer_bg');
$reland_footer_bg_url_from_page = function_exists('get_field') ? get_field('reland_footer_bg') : '';
$reland_footer_bg_color_from_page = function_exists('get_field') ? get_field('reland_footer_bg_color') : '';
$footer_bg_color = get_theme_mod('reland_footer_bg_color');

// Footer Social
$reland_show_footer_social = get_theme_mod('reland_show_footer_social', false);
$reland_footer_facebook_url = get_theme_mod('reland_footer_facebook_url', __('#', 'reland'));
$reland_footer_instagram_url = get_theme_mod('reland_footer_instagram_url', __('#', 'reland'));
$reland_footer_twitter_url = get_theme_mod('reland_footer_twitter_url', __('#', 'reland'));
$reland_footer_linkedin_url = get_theme_mod('reland_footer_linkedin_url', __('#', 'reland'));
$reland_footer_telegram_url = get_theme_mod('reland_footer_telegram_url');
$reland_footer_youtube_url = get_theme_mod('reland_footer_youtube_url');
$reland_footer_discord_url = get_theme_mod('reland_footer_discord_url');
$reland_footer_whatsapp_url = get_theme_mod('reland_footer_whatsapp_url');

$copyright_margin = $reland_show_footer_social ? 'margin-default' : 'mb-0';
$footer_bottom_padding = $reland_show_footer_social ? 'footer-bottom' : 'footer-bottom hide-footer-social';

// BG Image
$bg_img = !empty($reland_footer_bg_url_from_page['url']) ? $reland_footer_bg_url_from_page['url'] : $footer_bg_img;


// BG Color
$bg_color = !empty($reland_footer_bg_color_from_page) ? $reland_footer_bg_color_from_page : $footer_bg_color;


// Footer Columns
$footer_columns = 0;
$footer_widgets = get_theme_mod('footer_widget_number', 4);

for ($num = 1; $num <= $footer_widgets; $num++) {
    if (is_active_sidebar('footer-' . $num)) {
        $footer_columns++;
    }
}

switch ($footer_columns) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-lg-4 col-md-6';
        $footer_class[2] = 'col-lg-4 col-md-6 col-sm-6';
        $footer_class[3] = 'col-lg-4 col-md-6 col-sm-6';
        break;
    case '4':
        $footer_class[1] = 'col-xl-3 col-md-4 col-sm-5';
        $footer_class[2] = 'col-xl-3 col-md-4 col-sm-7';
        $footer_class[3] = 'col-xl-3 col-md-4 col-sm-5';
        $footer_class[4] = 'col-xl-3 col-md-5 col-sm-7';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-4 col-sm-6';
        break;
}

?>


<!-- footer-area -->
<footer>
    <div class="footer-area footer-bg" data-bg-color="<?php print esc_attr($bg_color); ?>" data-background="<?php print esc_url($bg_img); ?>">
        <div class="container">
            <?php if (is_active_sidebar('footer-1') or is_active_sidebar('footer-2') or is_active_sidebar('footer-3') or is_active_sidebar('footer-4')) : ?>
                <div class="footer-top">
                    <div class="row">
                        <?php
                        if ($footer_columns < 4) {
                            print '<div class="col-xl-3 col-md-4 col-sm-5">';
                            dynamic_sidebar('footer-1');
                            print '</div>';

                            print '<div class="col-xl-3 col-md-4 col-sm-7">';
                            dynamic_sidebar('footer-2');
                            print '</div>';

                            print '<div class="col-xl-3 col-md-4 col-sm-5">';
                            dynamic_sidebar('footer-3');
                            print '</div>';

                            print '<div class="col-xl-3 col-md-5 col-sm-7">';
                            dynamic_sidebar('footer-4');
                            print '</div>';
                        } else {
                            for ($num = 1; $num <= $footer_columns; $num++) {
                                if (!is_active_sidebar('footer-' . $num)) {
                                    continue;
                                }
                                print '<div class="' . esc_attr($footer_class[$num]) . '">';
                                dynamic_sidebar('footer-' . $num);
                                print '</div>';
                            }
                        }
                        ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="<?php echo esc_attr($footer_bottom_padding); ?>">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="copyright-text text-center">
                            <p class="<?php echo esc_attr($copyright_margin); ?>"><?php print reland_copyright_text(); ?></p>
                        </div>

                        <?php if (!empty($reland_show_footer_social)) : ?>
                            <div class="footer-social">
                                <ul class="list-wrap">
                                    <?php if (!empty($reland_footer_facebook_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_facebook_url); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_instagram_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_instagram_url); ?>"><i class="fab fa-instagram"></i></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_twitter_url)) : ?>
                                        <li>
                                            <a href="<?php echo esc_url($reland_footer_twitter_url); ?>">
                                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M8.33192 5.92804L13.5438 0H12.3087L7.78328 5.14724L4.16883 0H0L5.46575 7.78353L0 14H1.2351L6.01407 8.56431L9.83119 14H14L8.33192 5.92804ZM6.64027 7.85211L6.08648 7.07704L1.68013 0.909771H3.57718L7.13316 5.88696L7.68694 6.66202L12.3093 13.1316H10.4123L6.64027 7.85211Z" fill="currentColor" />
                                                </svg>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_linkedin_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_linkedin_url); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_telegram_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_telegram_url); ?>"><i class="fab fa-telegram-plane"></i></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_discord_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_discord_url); ?>"><i class="fab fa-discord"></i></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_youtube_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_youtube_url); ?>"><i class="fab fa-youtube"></i></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_footer_whatsapp_url)) : ?>
                                        <li><a href="<?php echo esc_url($reland_footer_whatsapp_url); ?>"><i class="fab fa-whatsapp"></i></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer-area-end -->