<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package reland
 */

get_header();
?>

<?php
    $error_background = get_template_directory_uri() . '/assets/img/images/error_shape.png';
    $reland_error_bg = get_theme_mod( 'reland_error_bg', $error_background );

    $reland_error_title = get_theme_mod('reland_error_title', __('The page you are looking for might have been removed or temporarily unavailable', 'reland'));
    $reland_error_link_text = get_theme_mod('reland_error_link_text', __('Back to home', 'reland'));
?>
<!-- error-area -->
<section class="error-area">
    <div class="error-shape" style="background-image: url(<?php print esc_url( $reland_error_bg ); ?>);"></div>
    <div class="container">
        <div class="row">
            <div class="col-xl-10">
                <div class="error-content">
                    <h2 class="title"><?php print esc_html($reland_error_title);?></h2>
                    <a href="<?php print esc_url(home_url('/'));?>" class="btn">
                        <div class="btn_m">
                            <div class="btn_c">
                                <div class="btn_t1"><?php print esc_html($reland_error_link_text);?></div>
                                <div class="btn_t2"><?php print esc_html($reland_error_link_text);?></div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="copyright-text">
        <p><?php print reland_copyright_text(); ?></p>
    </div>
</section>
<!-- error-area-end -->

<?php
get_footer();